% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R, R/gen-namespace.R
\name{torch_take_along_dim}
\alias{torch_take_along_dim}
\title{Selects values from input at the 1-dimensional indices from indices along the given dim.}
\usage{
torch_take_along_dim(self, indices, dim = NULL)
}
\arguments{
\item{self}{the input tensor.}

\item{indices}{the indices into input. Must have long dtype.}

\item{dim}{the dimension to select along. Default is \code{NULL}.}
}
\description{
Selects values from input at the 1-dimensional indices from indices along the given dim.
}
\note{
If dim is \code{NULL}, the input array is treated as if it has been flattened to 1d.

Functions that return indices along a dimension, like \code{\link[=torch_argmax]{torch_argmax()}} and \code{\link[=torch_argsort]{torch_argsort()}},
are designed to work with this function. See the examples below.
}
\examples{
if (torch_is_installed()) {
t <- torch_tensor(matrix(c(10, 30, 20, 60, 40, 50), nrow = 2))
max_idx <- torch_argmax(t)
torch_take_along_dim(t, max_idx)

sorted_idx <- torch_argsort(t, dim=2)
torch_take_along_dim(t, sorted_idx, dim=2)

}
}
