% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{scatterplot_fitted_vs_true}
\alias{scatterplot_fitted_vs_true}
\title{Plot Fitted vs. True Dissimilarities}
\usage{
scatterplot_fitted_vs_true(
  dissimilarity_matrix,
  p_dissimilarity_mat,
  scenario_name,
  ndim,
  save_plot = FALSE,
  output_dir,
  confidence_level = 0.95
)
}
\arguments{
\item{dissimilarity_matrix}{Matrix of true dissimilarities.}

\item{p_dissimilarity_mat}{Matrix of predicted/fitted dissimilarities.}

\item{scenario_name}{Character string for output file naming. Used if \code{save_plot} is TRUE.}

\item{ndim}{Integer number of dimensions used in the model.}

\item{save_plot}{Logical. Whether to save plots to files. Default: FALSE.}

\item{output_dir}{Character. Directory for output files. Required if \code{save_plot} is TRUE.}

\item{confidence_level}{Numeric confidence level for prediction intervals (default: 0.95).}
}
\value{
A list containing the \code{scatter_plot} and \code{residuals_plot} ggplot objects.
}
\description{
Creates diagnostic plots comparing fitted dissimilarities from a model against the true
dissimilarities. It generates both a scatter plot with an identity line and
prediction intervals, and a residuals plot.
}
\examples{
# Create sample data
true_dist <- matrix(runif(100, 1, 10), 10, 10)
pred_dist <- true_dist + rnorm(100)

# Create plots without saving
plots <- scatterplot_fitted_vs_true(
  dissimilarity_matrix = true_dist,
  p_dissimilarity_mat = pred_dist,
  save_plot = FALSE
 )

# You can then display a plot, for instance:
# plots$scatter_plot

}
