% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{clean_data}
\alias{clean_data}
\title{Clean Data by Removing MAD-based Outliers}
\usage{
clean_data(x, k = 3, take_log = FALSE)
}
\arguments{
\item{x}{Numeric vector to clean.}

\item{k}{Numeric threshold for outlier detection (default: 3).}

\item{take_log}{Logical. Deprecated parameter. Log transformation should be done before calling this function.}
}
\value{
A numeric vector of the same length as \code{x}, where detected outliers have been replaced with \code{NA}.
}
\description{
Removes outliers from numeric data using the Median Absolute Deviation (MAD) method.
Outliers are replaced with NA values.
}
\examples{
# Clean parameter values
params <- c(0.01, 0.012, 0.011, 0.1, 0.009, 0.011, 0.15)
clean_params <- clean_data(params)

}
\seealso{
\code{detect_outliers_mad} for the underlying outlier detection.
}
