% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{tinyVASTcontrol}
\alias{tinyVASTcontrol}
\title{Control parameters for tinyVAST}
\usage{
tinyVASTcontrol(
  nlminb_loops = 1,
  newton_loops = 0,
  eval.max = 1000,
  iter.max = 1000,
  getsd = TRUE,
  silent = getOption("tinyVAST.silent", TRUE),
  trace = getOption("tinyVAST.trace", 0),
  verbose = getOption("tinyVAST.verbose", FALSE),
  profile = c(),
  tmb_par = NULL,
  tmb_map = NULL,
  gmrf_parameterization = c("separable", "projection"),
  reml = FALSE,
  getJointPrecision = FALSE,
  calculate_deviance_explained = TRUE,
  run_model = TRUE,
  suppress_nlminb_warnings = TRUE,
  suppress_user_warnings = FALSE,
  get_rsr = FALSE,
  extra_reporting = FALSE,
  use_anisotropy = FALSE,
  sar_adjacency = "queen"
)
}
\arguments{
\item{nlminb_loops}{Integer number of times to call \code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{newton_loops}{Integer number of Newton steps to do after running
\code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{eval.max}{Maximum number of evaluations of the objective function
allowed. Passed to \code{control} in \code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{iter.max}{Maximum number of iterations allowed. Passed to \code{control} in
\code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{getsd}{Boolean indicating whether to call \code{\link[TMB:sdreport]{TMB::sdreport()}}}

\item{silent}{Disable terminal output for inner optimizer?}

\item{trace}{Parameter values are printed every \code{trace} iteration
for the outer optimizer. Passed to
\code{control} in \code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{verbose}{Output additional messages about model steps during fitting?}

\item{profile}{Parameters to profile out of the likelihood (this subset will be appended to \code{random} with Laplace approximation disabled).}

\item{tmb_par}{list of parameters for starting values, with shape identical
to \code{tinyVAST(...)$internal$parlist}}

\item{tmb_map}{input passed to \link[TMB:MakeADFun]{TMB::MakeADFun} as argument \code{map}, over-writing
the version \code{tinyVAST(...)$tmb_inputs$tmb_map} and allowing detailed control
over estimated parameters (advanced feature)}

\item{gmrf_parameterization}{Parameterization to use for the Gaussian Markov
random field, where the default \code{separable} constructs a full-rank and
separable precision matrix, and the alternative \code{projection} constructs
a full-rank and IID precision for variables over time, and then projects
this using the inverse-cholesky of the precision, where this projection
allows for rank-deficient covariance.}

\item{reml}{Logical: use REML (restricted maximum likelihood) estimation rather than
maximum likelihood? Internally, this adds the fixed effects to the
list of random effects to integrate over.}

\item{getJointPrecision}{whether to get the joint precision matrix.  Passed
to \code{\link[TMB]{sdreport}}.}

\item{calculate_deviance_explained}{whether to calculate proportion of deviance
explained.  See \code{\link[=deviance_explained]{deviance_explained()}}}

\item{run_model}{whether to run the model of export TMB objects prior to compilation
(useful for debugging)}

\item{suppress_nlminb_warnings}{whether to suppress uniformative warnings
from \code{nlminb} arising when a function evaluation is NA, which
are then replaced with Inf and avoided during estimation}

\item{suppress_user_warnings}{whether to suppress warnings from
package author regarding dangerous or non-standard options}

\item{get_rsr}{Experimental option, whether to report restricted spatial
regression (RSR) adjusted estimator for covariate responses}

\item{extra_reporting}{Whether to report a much larger set of quantities via
\code{obj$env$report()}}

\item{use_anisotropy}{Whether to estimate two parameters representing
geometric anisotropy}

\item{sar_adjacency}{Whether to use queen or rook adjacency when defining
a Simultaneous Autoregressive spatial precision from a sfc_GEOMETRY
(default is queen)}
}
\value{
An object (list) of class \code{tinyVASTcontrol}, containing either default or
updated values supplied by the user for model settings
}
\description{
Control parameters for tinyVAST
}
