% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conama.R
\name{conama_report}
\alias{conama_report}
\title{CONAMA conformity report (table)}
\usage{
conama_report(
  df,
  classe = "2",
  only_violations = TRUE,
  pretty = FALSE,
  decimal_mark = ",",
  big_mark = "."
)
}
\arguments{
\item{df}{Input data}

\item{classe}{CONAMA class label (e.g., "2")}

\item{only_violations}{If TRUE, returns only rows with \code{status != "ok"}}

\item{pretty}{If TRUE, returns formatted numeric columns for display}

\item{decimal_mark}{Decimal separator (default \code{","})}

\item{big_mark}{Thousands separator (default \code{"."})}
}
\value{
A tibble. When \code{pretty = FALSE}:
\code{parametro}, \code{valor}, \code{lim_min}, \code{lim_max},
\code{status}, \code{delta}. When \code{pretty = TRUE}, numeric columns
are formatted as character with "natural" decimals.
}
\description{
CONAMA conformity report (table)
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
conama_report(wq_demo, classe = "2", only_violations = TRUE)
conama_report(wq_demo, classe = "2", only_violations = TRUE, pretty = TRUE)
}

}
\seealso{
\code{\link[=conama_summary]{conama_summary()}}, \code{\link[=conama_text]{conama_text()}}
}
