% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvecost.R
\name{solvecost_chem}
\alias{solvecost_chem}
\title{Determine chemical cost}
\usage{
solvecost_chem(dose, flow, strength = 100, cost, time = "day")
}
\arguments{
\item{dose}{Chemical dose in mg/L as chemical}

\item{flow}{Plant flow in MGD}

\item{strength}{Chemical product strength in percent. Defaults to 100 percent.}

\item{cost}{Chemical product cost in $/lb}

\item{time}{Desired output units, one of c("day", "month", "year"). Defaults to "day".}
}
\value{
A numeric value for chemical cost, $/time.
}
\description{
This function takes a chemical dose in mg/L, plant flow, chemical strength, and $/lb and calculates cost.
}
\examples{
alum_cost <- solvecost_chem(dose = 20, flow = 10, strength = 49, cost = .22)

library(dplyr)
cost_data <- tibble(
  dose = seq(10, 50, 10),
  flow = 10
) \%>\%
  mutate(costs = solvecost_chem(dose = dose, flow = flow, strength = 49, cost = .22))

}
