% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectation.R
\name{expectation}
\alias{expectation}
\alias{new_expectation}
\alias{exp_signal}
\alias{is.expectation}
\title{Expectation conditions}
\usage{
expectation(type, message, ..., srcref = NULL, trace = NULL)

new_expectation(
  type,
  message,
  ...,
  srcref = NULL,
  trace = NULL,
  .subclass = NULL
)

exp_signal(exp)

is.expectation(x)
}
\arguments{
\item{type}{Expectation type. Must be one of "success", "failure", "error",
"skip", "warning".}

\item{message}{Message describing test failure}

\item{...}{Additional attributes for the expectation object.}

\item{srcref}{Optional \code{srcref} giving location of test.}

\item{trace}{An optional backtrace created by \code{\link[rlang:trace_back]{rlang::trace_back()}}.
When supplied, the expectation is displayed with the backtrace.
Expert use only.}

\item{.subclass}{An optional subclass for the expectation object.}

\item{exp}{An expectation object, as created by
\code{\link[=new_expectation]{new_expectation()}}.}

\item{x}{object to test for class membership}
}
\description{
\code{new_expectation()} creates an expectation condition object and
\code{exp_signal()} signals it. \code{expectation()} does both. \code{is.expectation()}
tests if a captured condition is a testthat expectation.

These functions are primarily for internal use. If you are creating your
own expectation, you do not need these functions are instead should use
\code{\link[=pass]{pass()}} or \code{\link[=fail]{fail()}}. See \code{vignette("custom-expectation")} for more
details.
}
\keyword{internal}
