% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapQuery.R
\name{mapQuery}
\alias{mapQuery}
\title{Function for mapping query cells to a Symphony reference}
\usage{
mapQuery(
  exp_query,
  metadata_query,
  ref_obj,
  vars = NULL,
  verbose = TRUE,
  do_normalize = TRUE,
  do_umap = TRUE,
  sigma = 0.1
)
}
\arguments{
\item{exp_query}{Query gene expression (genes by cells)}

\item{metadata_query}{Query metadata (cells by attributes)}

\item{ref_obj}{Reference object as returned by Symphony buildReference()}

\item{vars}{Query batch variable(s) to integrate over (column names in metadata)}

\item{verbose}{Verbose output}

\item{do_normalize}{Perform log(CP10K+1) normalization on query expression}

\item{do_umap}{Perform umap projection into reference UMAP (if reference includes a uwot model)}

\item{sigma}{Fuzziness parameter for soft clustering (sigma = 1 is hard clustering)}
}
\value{
Symphony query object. Mapping embedding is in the $Z slot. Other slots include
query expression matrix ($exp), query cell-level metadata ($meta_data),
query cell embedding in pre-Harmonized reference PCs ($Zq_pca), query cell soft cluster
assignments ($R), and query cells in reference UMAP coordinates ($umap).
}
\description{
Function for mapping query cells to a Symphony reference
}
