% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam_model_rank.R
\name{gam_model_rank}
\alias{gam_model_rank}
\title{Ranks models by GCV, giving the model form for each predictor variable.}
\usage{
gam_model_rank(res_tab, n = 10)
}
\arguments{
\item{res_tab}{a \code{data.frame} returned from the \code{evaluate_models()} function.}

\item{n}{the number of ranked models to return.}
}
\value{
a \code{tibble} of the 'n' best models, ranked by GCV, with the form of each predictor variable where '---' indicates the absence of a predictor, 'Fixed' that a parametric form was specified,  's_S' a spatial smooth, 's_T'  a temporal smooth and 'te_ST' a spatio-temporal smooth.
}
\description{
Ranks models by GCV, giving the model form for each predictor variable.
}
\examples{
require(dplyr)
require(doParallel)
# define input data
data("hp_data")
input_data <-
  hp_data |>
  # create Intercept as an addressable term
  mutate(Intercept = 1)
# evaluate different model forms
svc_mods <-
  evaluate_models(
    input_data = input_data,
    target_var = "priceper",
    vars = c("pef"),
    coords_x = "X",
    coords_y = "Y",
    VC_type = "SVC",
    time_var = NULL,
    ncores = 2
  )
gam_model_rank(svc_mods)
}
