% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_casualties}
\alias{read_casualties}
\title{Read in STATS19 road safety data from .csv files downloaded.}
\usage{
read_casualties(
  year = NULL,
  filename = "",
  data_dir = get_data_directory(),
  format = TRUE
)
}
\arguments{
\item{year}{Single year for which data are to be read}

\item{filename}{Character string of the filename of the .csv to read, if this is given, type and
years determine whether there is a target to read, otherwise disk scan would be needed.}

\item{data_dir}{Where sets of downloaded data would be found.}

\item{format}{Switch to return raw read from file, default is \code{TRUE}.}
}
\description{
Read in STATS19 road safety data from .csv files downloaded.
}
\section{Details}{

The function returns a data frame, in which each record is a reported casualty
in the STATS19 dataset.
}

\examples{
\donttest{
if(curl::has_internet()) {
dl_stats19(year = 2022, type = "casualty")
casualties = read_casualties(year = 2022)
}
}
}
