% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagTests.R
\name{Portmanteau_test}
\alias{Portmanteau_test}
\title{Perform adjusted Portmanteau test for a STVAR model}
\usage{
Portmanteau_test(stvar, nlags = 20, which_test = c("autocorr", "het.sked"))
}
\arguments{
\item{stvar}{an object of class \code{'stvar'} generated by \code{fitSTVAR} or \code{STVAR}.}

\item{nlags}{a strictly positive integer specifying the number of lags to be tested.}

\item{which_test}{should test for remaining autocorrelation or heteroskedasticity be calculated?}
}
\value{
A list with class "hypotest" containing the test results and arguments used to calculate the test.
}
\description{
\code{Portmanteau_test} performs adjusted Portmanteau test for remaining autocorrelation
  (or heteroskedasticity) in the residuals of a STVAR model.
}
\details{
The implemented adjusted Portmanteau test is based on Lütkepohl (2005), Section 4.4.3.
  When testing for remaining heteroskedasticity, the Portmanteau test is applied to squared
  standardized residuals that are centered to have zero mean. Note that the validity of the
  heteroskedasticity test requires that the residuals are not autocorrelated.
}
\examples{
# Gaussian STVAR p=2, M=2, model with weighted relative stationary densities
# of the regimes as the transition weight function:
theta_222relg <- c(0.357, 0.107, 0.356, 0.086, 0.14, 0.035, -0.165, 0.387, 0.452,
 0.013, 0.228, 0.336, 0.239, 0.024, -0.021, 0.708, 0.063, 0.027, 0.009, 0.197,
 0.206, 0.005, 0.026, 1.092, -0.009, 0.116, 0.592)
mod222relg <- STVAR(data=gdpdef, p=2, M=2, d=2, params=theta_222relg,
 weight_function="relative_dens")

# Test for remaining autocorrelation taking into account the first 20 lags:
Portmanteau_test(mod222relg, nlags=20)

# Test for remaining heteroskedasticity taking into account the first 20 lags:
Portmanteau_test(mod222relg, nlags=20, which_test="het.sked")

# Two-regime Student's t Threhold VAR p=3 model with the first lag of the second
# variable as the switching variable:
theta_322thres <- c(0.527, 0.039, 1.922, 0.154, 0.284, 0.053, 0.033, 0.453, 0.291,
 0.024, -0.108, 0.153, -0.108, 0.003, -0.128, 0.219, 0.195, -0.03, -0.893, 0.686,
 0.047, 0.016, 0.524, 0.068, -0.025, 0.044, -0.435, 0.119, 0.359, 0.002, 0.038,
 1.252, -0.041, 0.151, 1.196, 12.312)
mod322thres <- STVAR(data=gdpdef, p=3, M=2, d=2, params=theta_322thres,
 weight_function="threshold", weightfun_pars=c(2, 1), cond_dist="Student")

# Test for remaining autocorrelation taking into account the first 25 lags:
Portmanteau_test(mod322thres, nlags=25)

# Test for remaining heteroskedasticity taking into account the first 25 lags:
Portmanteau_test(mod322thres, nlags=25, which_test="het.sked")
}
\references{
\itemize{
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
           \emph{Springer}.
  }
}
\seealso{
\code{\link{LR_test}}, \code{\link{Rao_test}}, \code{\link{fitSTVAR}}, \code{\link{STVAR}},
  \code{\link{diagnostic_plot}}, \code{\link{profile_logliks}},
}
