% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_parameters.R
\name{contamination_random}
\alias{contamination_random}
\title{Contamination Through Swapping}
\usage{
contamination_random(cont, data)
}
\arguments{
\item{cont}{numeric, amount of contamination in data.}

\item{data}{data whose observations should be switched.}
}
\value{
A matrix with switched observations.
}
\description{
This function swaps observations completely random in order to introduce contamination
in the data. Used in \code{\link[ssMRCD]{parameter_tuning}}.
}
\examples{
# set seed
set.seed(1)

# get data
data(weatherAUT2021)

# switch 5\% of observations
contamination_random(cont = 0.05, data = weatherAUT2021[,1:6])
}
