% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc_methods.R
\name{plot_loadings}
\alias{plot_loadings}
\title{Plots of loadings of PCAloc object}
\usage{
plot_loadings(object, ...)
}
\arguments{
\item{object}{object of class PCAloc}

\item{...}{other input arguments, see details.}
}
\value{
Returns loading heatmap for component \code{k}.
}
\description{
Plots of loadings of PCAloc object
}
\details{
Additional parameters that can be given to the function are: \tabular{ll}{
   \code{text} \tab logical if values should be added as text.  \cr
   \tab \cr
   \code{size} \tab point size.\cr
   \tab \cr
   \code{tolerance} \tab tolerance for rounding to zero.\cr
   \tab \cr
   \code{k} \tab integer, which component scores should be plotted. \cr
   \tab \cr
   \code{groupnames} \tab names of groups. \cr
   \tab \cr
   \code{varnames} \tab names of variables. \cr
   \tab \cr
   \code{textrotate} \tab angle of text rotation, if included.\cr
   \tab \cr
}
}
\examples{
# set seed
set.seed(236)

data = matrix(rnorm(2000), ncol = 4)
groups = sample(1:10, 500, replace = TRUE)
W = time_weights(N = 10, c(3,2,1))

# calculate covariance matrices
covs = ssMRCD(data, groups = groups, weights = W, lambda = 0.3)

# sparse PCA
pca = sparsePCAloc(eta = 0.3, gamma = 0.7, cor = FALSE, COVS = covs$MRCDcov,
             n_max = 1000, increase_rho = list(TRUE, 50, 1), trace = FALSE)

# plot score distances
plot_loadings(object = pca,
            k = 1,
            size = 2)
}
