% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srppp-xml.R
\name{srppp_dm}
\alias{srppp_dm}
\alias{print.srppp_dm}
\title{Create a dm object from an XML version of the Swiss Register of Plant Protection Products}
\usage{
srppp_dm(from = srppp_xml_url, remove_duplicates = TRUE, verbose = TRUE)

\method{print}{srppp_dm}(x, ...)
}
\arguments{
\item{from}{A specification of the way to retrieve the XML to be passed to
\link{srppp_xml_get}, or an object of the class 'srppp_xml'}

\item{remove_duplicates}{Should duplicates based on wNbrs be removed?}

\item{verbose}{Should we give some feedback?}

\item{x}{A \link{srppp_dm} object}

\item{\dots}{Not used}
}
\value{
A \link[dm:dm]{dm::dm} object with tables linked by foreign keys
pointing to primary keys, i.e. with referential integrity.
Since version 1.1, the returned object has an attribute named 'culture_tree'
of class \link[data.tree:Node]{data.tree::Node}.
}
\description{
While reading in the data, the information obtained from the XML file is
left unchanged, with the exceptions listed in the section 'Details'.
An overview of the contents of the most important tables in the resulting
data object is given in \code{vignette("srppp")}.
}
\details{
\subsection{Corrections made to the data}{
\itemize{
\item In the following case, the product composition is corrected while reading in
the data: The active substance content of Dormex (W-3066) is not 667 g/L,
but 520 g/L This was confirmed by a visit to the Wädenswil archive by
Johannes Ranke and Daniel Baumgartner, 2024-03-27.
}
}

\subsection{Removal of redundant information}{
\itemize{
\item Information on products that has been duplicated across several products
sharing the same P-Number has been associated directly with this P-Number,
in order to avoid duplications. While reading in the XML file, it is checked
that the resulting deduplication does not remove any data.
\item In very few cases of historical XML files, there are two \verb{<Product>}
sections sharing the same W-Number. In these cases, one of these has apparently
been included in error and an informed decision is taken while reading in
the data which one of these sections is discarded. The details of this
procedure can be found in the source code of the function
\code{srppp_xml_get_products}.
}
}

\subsection{Amendments to the data}{

In the table of obligations, the following information on mitigation
measures is extracted from the ones relevant for the environment (SPe 3).
\itemize{
\item "sw_drift_dist": Unsprayed buffer towards surface waters to mitigate
spray drift in meters
\item "sw_runoff_dist": Vegetated buffer towards surface waters to mitigate
runoff in meters
\item "sw_runoff_points": Required runoff mitigation points to mitigate runoff
\item "biotope_drift_dist": Unsprayed buffer towards biotopes (as defined in
articles 18a and 18b of the Federal Act on the Protection of Nature and
Cultural Heritage) to mitigate spray drift in meters
}
}
}
\examples{
\donttest{ # Avoid NOTE on CRAN caused by checks >5s
library(dplyr, warn.conflicts = FALSE)
library(dm, warn.conflicts = FALSE)

sr <- try(srppp_dm())

# Fall back to internal test data if downloading or reading fails
if (inherits(sr, "try-error")) {
  sr <- system.file("testdata/Daten_Pflanzenschutzmittelverzeichnis_2024-12-16.zip",
      package = "srppp") |>
    srppp_xml_get_from_path(from = "2024-12-16") |>
    srppp_dm()
}

dm_examine_constraints(sr)
dm_draw(sr)

# Show ingredients for products named 'Boxer'
sr$products |>
  filter(name == "Boxer") |>
  left_join(sr$ingredients, by = "pNbr") |>
  left_join(sr$substances, by = "pk") |>
  select(wNbr, name, pNbr, isSalePermission, substance_de, g_per_L)

# Show authorised uses of the original product
boxer_uses <- sr$products |>
  filter(name == "Boxer", !isSalePermission) |>
  left_join(sr$uses, by = "pNbr") |>
  select(pNbr, use_nr,
    min_dosage, max_dosage, min_rate, max_rate, units_de,
    waiting_period, time_units_de, application_area_de)
print(boxer_uses)

# Show crop for use number 1
boxer_uses |>
  filter(use_nr == 1) |>
  left_join(sr$cultures, join_by(pNbr, use_nr)) |>
  select(use_nr, culture_de)

# Show target pests for use number 1
boxer_uses |>
  filter(use_nr == 1) |>
  left_join(sr$pests, join_by(pNbr, use_nr)) |>
  select(use_nr, pest_de)

# Show obligations for use number 1
boxer_uses |>
  filter(use_nr == 1) |>
  left_join(sr$obligations, join_by(pNbr, use_nr)) |>
  select(use_nr, sw_runoff_points, obligation_de) |>
  knitr::kable() |>
  print()

# Show application comments for use number 1
boxer_uses |>
  filter(use_nr == 1) |>
  left_join(sr$application_comments, join_by(pNbr, use_nr)) |>
  select(use_nr, application_comment_de)

# Illustrate 'obligations' indicating varying effects
sr$obligations |>
  filter(varying_effect) |>
  select(pNbr, use_nr, code, obligation_de)

}
}
