% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/he10.R
\name{he10}
\alias{he10}
\title{Measles in UK: spatPomp generator with shared or unit-specific parameters}
\usage{
he10(
  U = 6,
  dt = 2/365,
  Tmax = 1964,
  expandedParNames = c("alpha", "iota", "R0", "cohort", "amplitude", "gamma", "sigma",
    "sigmaSE", "rho", "psi", "g", "S_0", "E_0", "I_0"),
  basic_params = c(alpha = 1, iota = 0, R0 = 30, cohort = 0, amplitude = 0.5, gamma = 52,
    sigma = 52, mu = 0.02, sigmaSE = 0.15, rho = 0.5, psi = 0.15, g = 400, S_0 = 0.032,
    E_0 = 5e-05, I_0 = 4e-05),
  towns_selected = NULL
)
}
\arguments{
\item{U}{A length-one numeric signifying the number of cities to be
represented in the spatPomp object. Default U=20 gives all the towns
studied by He et al., the 10 largest and 10 selected smaller towns.}

\item{dt}{a numeric (in unit of years) that is used as the Euler time-increment for simulating measles data.}

\item{Tmax}{Upper time for the window used to construct the object. The lower time is fixed at 1950.0. The default value matches He et al (2010).}

\item{expandedParNames}{specifies the names of parameters which take unit-specific values. Remaining parameters take a single, shared value for all units.}

\item{basic_params}{A candidate parameter vector in the basic format, i.e., no unit-specific parameters or unit-related name extensions.}

\item{towns_selected}{A numeric vector of towns to be modeled. Defaults 
to 1:U, with cities ranked by decreasing population and 1 being London.}
}
\value{
An object of class \sQuote{spatPomp} representing a \code{U}-dimensional spatially coupled measles POMP model.
}
\description{
Generate a spatPomp object for measles adding spatial coupling to
The model and data from He et al. (2010) with gravity transport as
in Park and Ionides (2020). Other transport models may be added in future.
The data in the object matches He et al. (2010). The model matches
that analysis in the specific case where there is no coupling and all
parameters are unit-specific.
}
\details{
The code for this spatPomp has duplication with measles(), but in future
the two models may diverge. The measles() spatPomp is a simplified
situation useful for testing some methods. However, measles() does not
permit unit-specific parameters, which he10() allows. Also, 
the structure of this spatPomp is compatible with the spatiotemporal 
iterated filtering algorithm ibpf(). This requires shared parameters to
be represented with a value for each unit, which should be the same for each
unit in a valid model instance but may vary between units while optimizing.
}
\note{
This function goes through a typical workflow of constructing
a typical spatPomp object (1-4 below). This allows the user to have a
file that replicates the exercise of model building as well as function
that creates a typical nonlinear model in epidemiology in case they want
to test a new inference methodology. We purposely do not modularize this
function because it is not an operational piece of the package and is
instead useful as an example.\cr
1. Getting a measurements data.frame with columns for times,
   spatial units and measurements.\cr
2. Getting a covariates data.frame with columns for times,
   spatial units and covariate data.\cr
3. Constructing model components (latent state initializer,
   latent state transition simulator and measurement model). Depending
   on the methods used, the user may have to supply a vectorfield to
   be integrated that represents the deterministic skeleton of the latent
   process.\cr
4. Bringing all the data and model components together to form a
   spatPomp object via a call to spatPomp().
}
\section{Relationship to published analysis}{

The model generator \code{he10()} differs from \code{measles()} in some details necessitated to reproduce the results of He et al (2010).
The \code{measles()} model follows the decision of Park and Ionides (2020) and Ionides et al (2021) to apply the mixing exponent \eqn{\alpha_u} to \eqn{(I_u/P_u)} rather than just to \eqn{I_u}.
\code{he10()} does this for the infections arising from individuals traveling to another town (which don't arise for the panel model of He et al (2010)).
However, for infections arising within a city, in order to reproduce the results of He et al (2010), \code{he10()} uses \eqn{(I_u^{\alpha_u}/P_u)}.
This is not fully documented in the text of Ionides et al (2022).
Models fitted to data have \eqn{alpha_u} close to \eqn{1}, so this issue may be negligible in practice.

Another discrepancy between the \code{he10()} code and the mathematical model written by Ionides et al (2022) arises in whether individuals traveling from \eqn{u} to \eqn{v} use mixing exponent \eqn{\alpha_u} or \eqn{\alpha_v}.
Ionides et al (2022) wrote \eqn{u} but the code used implemented \eqn{v}.
The implementation in \code{he10()} matches the implementation of Ionides et al (2022) and so uses \eqn{v}.

It might seem surprising that immigrant infections affect only the first term in the expression for \eqn{\mu_{SE}} in Ionides et al (2022), and in the corresponding \code{he10()} code.
This immigration term is needed in the first term to make the model of He et al (2010) a proper sub-model, when coupling is removed by setting the gravitational constant parameter equal to zero.
When this constant is allowed to be positive, the role of immigrant infections transmitting to traveling individuals is anticipated to be a negligible, second-order effect which has been omitted from the model.
}

\examples{
# Complete examples are provided in the package tests
\dontrun{
m <- he10(U = 5)
# See all the model specifications of the object
spy(m)
}
}
\references{
\asfaw2020

\he2010

\ionides2021

\ionides2022

\park2020
}
\seealso{
\code{he10coordinates}, \code{he10measles}, \code{he10mle}, \code{he10demography}

Other spatPomp model generators: 
\code{\link{bm}()},
\code{\link{bm2}()},
\code{\link{gbm}()},
\code{\link{lorenz}()},
\code{\link{measles}()}
}
\author{
Edward L. Ionides
}
\concept{spatPomp model generators}
