% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relaxation_fitting.R
\name{fit_t1_tr_array}
\alias{fit_t1_tr_array}
\title{Fit a T1 recovery curve, from multiple TRs, to a set of amplitudes.}
\usage{
fit_t1_tr_array(
  tr_vec,
  amp_vec,
  lower = 0,
  upper = 10,
  output_fit_res = 0.01,
  ret_full = TRUE
)
}
\arguments{
\item{tr_vec}{vector of TR values in seconds.}

\item{amp_vec}{vector of amplitudes.}

\item{lower}{minimum allowable T1 value.}

\item{upper}{maximum allowable T1 value.}

\item{output_fit_res}{temporal resolution (seconds) of the ideal output
relaxation curve.}

\item{ret_full}{return full fitting information including ideal relaxation
curve.}
}
\value{
a list containing relaxation parameters and an ideal curve for fit
evaluation.
}
\description{
Fit a T1 recovery curve, from multiple TRs, to a set of amplitudes.
}
