% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{back_extrap_ar}
\alias{back_extrap_ar}
\title{Back extrapolate time-domain data points using an autoregressive model.}
\usage{
back_extrap_ar(
  mrs_data,
  extrap_pts,
  pred_pts = NULL,
  method = "burg",
  rem_add = TRUE,
  ...
)
}
\arguments{
\item{mrs_data}{mrs_data object.}

\item{extrap_pts}{number of points to extrapolate.}

\item{pred_pts}{number of points to base the extrapolation on.}

\item{method}{character string specifying the method to fit the model. Must
be one of the strings in the default argument (the first few characters are
sufficient). Defaults to "burg".}

\item{rem_add}{remove additional points from the end of the FID to maintain
the original length of the dataset. Default to TRUE.}

\item{...}{additional arguments to specific methods, see ?ar.}
}
\value{
back extrapolated data.
}
\description{
Back extrapolate time-domain data points using an autoregressive model.
}
