% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcoise_meta.R
\name{sourcoise_meta}
\alias{sourcoise_meta}
\title{Returns sourcoise metadata on a script}
\usage{
sourcoise_meta(path, args = NULL)
}
\arguments{
\item{path}{(character) path of the script}

\item{args}{(named list) arguments of the script if any}
}
\value{
a named list with cache information
}
\description{
quick acces to metadata of the script, data is not fecthed.
}
\details{
\itemize{
\item \code{timing}: time of full script execution
\item \code{date}: date of last full execution
\item \code{size}: size of objects returned (in R memory)
\item \code{args}: args given to sourcoise for the script
\item \code{lapse}: dely before reexecution
\item \code{track}: list of files tracked
\item \code{qmd_file}: list of qmd calling this script
\item \code{log_file}: last log file
\item \code{file_size}: size of data cached on disk
\item \code{data_date}: date of last data save (if no new data when executed, no data is saved)
\item \code{data_file}: path to data cached (as a qs2 data file)
\item \code{file}: path to the json file storing metadata (and .sourcoise dir)
}
}
\examples{
dir <- tempdir()
set_sourcoise_root(dir)
fs::file_copy(
   fs::path_package("sourcoise", "some_data.R"),
  dir,
  overwrite = TRUE)
# Force execution (root is set explicitly here, it is normally deduced from project)
data <- sourcoise("some_data.R", force_exec = TRUE)
# Then we access metadata
sourcoise_meta("some_data.R")

}
