% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-seeds.R
\name{seeds_internal}
\alias{seeds_internal}
\alias{.seeds_check}
\alias{.seeds_check.data.frame}
\alias{.seeds_check.matrix}
\alias{.seeds_check.NULL}
\alias{.seeds_check.default}
\alias{.seeds_type}
\alias{.switch_seeds}
\alias{.append_seed}
\alias{.seeds}
\title{Internal seed utilities}
\usage{
.seeds_check(seeds)

\method{.seeds_check}{data.frame}(seeds)

\method{.seeds_check}{matrix}(seeds)

\method{.seeds_check}{`NULL`}(seeds)

\method{.seeds_check}{default}(seeds)

.seeds_type(seeds)

.switch_seeds(seeds, ...)

.append_seed(seeds, new_seed)

.seeds(...)
}
\arguments{
\item{seeds}{A data frame, matrix, or \code{NULL} describing seeds.}

\item{new_seed}{Single-row object to append to an existing seed set.}
}
\description{
Low-level helpers shared across the seed conversion and validation stack.
These functions never touch disk or user I/O; they simply standardize how
seeds are checked, typed, and appended so that downstream helpers can focus
on the conversions.
}
\section{Components}{

\describe{
  \item{\code{.seeds_check()}}{Generic plus methods that coerce arbitrary
  inputs into the required column pairs while emitting targeted errors.}
  \item{\code{.seeds_type()}}{Identifies which coordinate signature a seed
  object currently follows so that dispatchers can choose the right path.}
  \item{\code{.switch_seeds()}}{Wrapper around \code{switch()} that routes
  execution based on the detected type.}
  \item{\code{.append_seed()}}{Appends a single seed row after verifying the
  incoming and existing coordinate systems match.}
  \item{\code{.seeds()}}{Thin data.frame constructor with consistent defaults
  used throughout tests and helper code.}
}
}

\keyword{internal}
