% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjSDM.R
\name{predict.sjSDM}
\alias{predict.sjSDM}
\title{Predict from a fitted sjSDM model}
\usage{
\method{predict}{sjSDM}(
  object,
  newdata = NULL,
  SP = NULL,
  Y = NULL,
  type = c("link", "raw"),
  dropout = FALSE,
  ...
)
}
\arguments{
\item{object}{a model fitted by \code{\link{sjSDM}}}

\item{newdata}{newdata for predictions}

\item{SP}{spatial predictors (e.g. X and Y coordinates)}

\item{Y}{Known occurrences of species, must be a matrix of the original size, species to be predicted must consist of NAs}

\item{type}{raw or link}

\item{dropout}{use dropout for predictions or not, only supported for DNNs}

\item{...}{optional arguments for compatibility with the generic function, no function implemented}
}
\value{
Matrix of predictions (sites by species)
}
\description{
Predict from a fitted sjSDM model
}
\examples{
\dontrun{

## Conditional predictions based on focal species
com = simulate_SDM(sites = 200L)
## first 100 observations are the training data
model = sjSDM(com$response[1:100, ], com$env_weights[1:100,])
## Assume that for the other 100 observations, only the first species is missing 
## and we want to use the other 4 species to improve the predictions:
Y_focal = com$response[101:200, ]
Y_focal[,1] = NA # set to NA because occurrences are unknown

pred_conditional = predict(model, newdata = com$env_weights[101:200,], Y = Y_focal)
pred_unconditional = predict(model, newdata = com$env_weights[101:200,])[,1]

## Compare performance:
Metrics::auc(com$response[101:200, 1], pred_conditional)
Metrics::auc(com$response[101:200, 1], pred_unconditional)

## Conditional predictions are better, however, it only works if occurrences of
## other species for new sites are known!

}
}
