% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.som_evaluate_cluster}
\alias{plot.som_evaluate_cluster}
\title{Plot confusion between clusters}
\usage{
\method{plot}{som_evaluate_cluster}(x, y, ..., name_cluster = NULL, title = "Confusion by cluster")
}
\arguments{
\item{x}{Object of class "plot.som_evaluate_cluster".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}

\item{name_cluster}{Choose the cluster to plot.}

\item{title}{Title of plot.}
}
\value{
A plot object produced by the ggplot2 package
                     containing color bars showing the confusion
                     between classes.
}
\description{
Plot a bar graph with informations about each cluster.
The percentage of mixture between the clusters.
}
\examples{
if (sits_run_examples()) {
    # create a SOM map
    som_map <- sits_som_map(samples_modis_ndvi)
    # evaluate the SOM cluster
    som_clusters <- sits_som_evaluate_cluster(som_map)
    # plot the SOM cluster evaluation
    plot(som_clusters)
}
}
\author{
Lorena Santos \email{lorena.santos@inpe.br}
}
