% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{modwt_wvar_cpp}
\alias{modwt_wvar_cpp}
\title{Computes the (MODWT) wavelet variance}
\usage{
modwt_wvar_cpp(
  signal,
  nlevels,
  robust,
  eff,
  alpha,
  ci_type,
  strWavelet,
  decomp
)
}
\arguments{
\item{signal}{A \code{vec} that contains the data.}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}

\item{alpha}{A \code{double} that indicates the \eqn{\left(1-p\right)\times \alpha}{(1-p)*alpha} confidence level}

\item{ci_type}{A \code{string} indicating the confidence interval being calculated. Valid value: "eta3"}

\item{strWavelet}{A \code{string} indicating the type of wave filter to be applied. Must be "haar"}

\item{decomp}{A \code{string} indicating whether to use "modwt" or "dwt" decomp}
}
\value{
A \code{mat} with the structure:
\itemize{
  \item{"variance"}{Wavelet Variance}
  \item{"low"}{Lower CI}
  \item{"high"}{Upper CI}
}
}
\description{
Calculates the (MODWT) wavelet variance
}
\details{
This function powers the wvar object. It is also extendable...
}
\keyword{internal}
