% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlite_db.R
\name{db.read_table}
\alias{db.read_table}
\title{Read remote database tables into data frames with additional
  validation}
\usage{
db.read_table(con, table, schema = NA, collect = TRUE, error_value = NA)
}
\arguments{
\item{con}{An object that inherits from
\code{\link[=DBI]{DBIConnection-class}}, typically generated by
\code{\link[=DBI]{dbConnect()}}}

\item{table}{A character string specifying the DBMS table name.}

\item{schema}{A character string specifying the schema in which the table is
nested.}

\item{collect}{A logical specifying whether the query results should be
collected into memory or left as a lazy query.}

\item{error_value}{Error value to return if \code{\link[=DBI]{dbReadTable()}}
fails. Default is \code{NA}.}
}
\value{
If the SQL query executes successfully, the return value will be an
  object of class \code{\link[=tibble]{tibble}}. If an error is encountered,
  the return value will be inherited from the \code{error_value} argument
  provided (default is \code{NA}).
}
\description{
Wrapper function to read table from default or custom schema,
  and return \code{NA} by default if an error is encountered.
}
\examples{
con <- connect_sqlite(auto_disconnect = FALSE)
dplyr::copy_to(con, iris, "df", temporary = FALSE)
db.read_table(con = con, table = 'df')

}
