% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{get_iterative_args_default}
\alias{get_iterative_args_default}
\title{Function to specify arguments of the iterative estimation procedure}
\usage{
get_iterative_args_default(
  internal,
  initial_n_coalitions = ceiling(min(200, max(5, internal$parameters$n_features,
    (2^internal$parameters$n_features)/10), internal$parameters$max_n_coalitions)),
  fixed_n_coalitions_per_iter = NULL,
  max_iter = 20,
  convergence_tol = 0.02,
  n_coal_next_iter_factor_vec = c(seq(0.1, 1, by = 0.1), rep(1, max_iter - 10))
)
}
\arguments{
\item{internal}{List.
Not used directly, but passed through from \code{\link[=explain]{explain()}}.}

\item{initial_n_coalitions}{Integer. Number of coalitions to use in the first estimation iteration.}

\item{fixed_n_coalitions_per_iter}{Integer. Number of \code{n_coalitions} to use in each iteration.
\code{NULL} (default) means setting it based on estimates based on a set convergence threshold.}

\item{max_iter}{Integer. Maximum number of estimation iterations}

\item{convergence_tol}{Numeric. The t variable in the convergence threshold formula on page 6 in the paper
Covert and Lee (2021), 'Improving KernelSHAP: Practical Shapley Value Estimation via Linear Regression'
https://arxiv.org/pdf/2012.01536. Smaller values requires more coalitions before convergence is reached.}

\item{n_coal_next_iter_factor_vec}{Numeric vector. The number of \code{n_coalitions} that must be used to reach
convergence in the next iteration is estimated.
The number of \code{n_coalitions} actually used in the next iteration is set to this estimate multiplied by
\code{n_coal_next_iter_factor_vec[i]} for iteration \code{i}.
It is wise to start with smaller numbers to avoid using too many \code{n_coalitions} due to uncertain estimates in
the first iterations.}
}
\value{
A list with the default values for the iterative estimation procedure
}
\description{
Function to specify arguments of the iterative estimation procedure
}
\details{
The functions sets default values for the iterative estimation procedure, according to the function
defaults.
If the argument \code{iterative} of \code{\link[=explain]{explain()}} is FALSE, it sets parameters corresponding to the use of a
non-iterative estimation procedure
}
\author{
Martin Jullum
}
