% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_iter}
\alias{cli_iter}
\title{Printing messages in iterative procedure with cli}
\usage{
cli_iter(verbose, internal, iter)
}
\arguments{
\item{verbose}{String vector or NULL.
Controls verbosity (printout detail level) via one or more of \code{"basic"}, \code{"progress"},
\code{"convergence"}, \code{"shapley"} and \code{"vS_details"}.
\code{"basic"} (default) displays basic information about the computation and messages about parameters/checks.
\code{"progress"} displays where in the calculation process the function currently is.
\code{"convergence"} displays how close the Shapley value estimates are to convergence
(only when \code{iterative = TRUE}).
\code{"shapley"} displays intermediate Shapley value estimates and standard deviations (only when \code{iterative = TRUE}),
and the final estimates.
\code{"vS_details"} displays information about the v(S) estimates,
most relevant for \code{approach \%in\% c("regression_separate", "regression_surrogate", "vaeac")}.
\code{NULL} means no printout.
Any combination can be used, e.g., \code{verbose = c("basic", "vS_details")}.}

\item{internal}{List.
Not used directly, but passed through from \code{\link[=explain]{explain()}}.}

\item{iter}{Integer.
The iteration number. Only used internally.}
}
\value{
No return value (but prints iterative messages with cli)
}
\description{
Printing messages in iterative procedure with cli
}
\keyword{internal}
