% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_get_optimizer}
\alias{vaeac_get_optimizer}
\title{Function to create the optimizer used to train \code{vaeac}}
\usage{
vaeac_get_optimizer(vaeac_model, lr, optimizer_name = "adam")
}
\arguments{
\item{vaeac_model}{A \code{vaeac} model created using \code{\link[=vaeac]{vaeac()}}.}

\item{lr}{Positive numeric (default is \code{0.001}). The learning rate used in the \code{\link[torch:optim_adam]{torch::optim_adam()}} optimizer.}

\item{optimizer_name}{String containing the name of the \code{\link[torch:optimizer]{torch::optimizer()}} to use.}
}
\value{
A \code{\link[torch:optim_adam]{torch::optim_adam()}} optimizer connected to the parameters of the \code{vaeac_model}.
}
\description{
Only \code{\link[torch:optim_adam]{torch::optim_adam()}} is currently supported. But it is easy to add an additional option later.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
