% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_variables.R
\name{calcXY}
\alias{calcXY}
\title{Calculate (x, y) coordinates}
\usage{
calcXY(list)
}
\arguments{
\item{list}{A list of data frame objects with columns dx and dy.}
}
\value{
Converts dx and dy values to (x, y) coordinates.
}
\description{
Calculates (x,y) coordinates from dx and dy values
}
\details{
Use the dx and dy columns in the servosphere data frames to calculate the (x,
y) coordinate for each position recording. If the data will be aggregated, it is
recommended to aggregate the data before running this function.
}
\examples{
 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))
servosphere <- calcXY(servosphere)
}
