% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chainsDistances}
\alias{chainsDistances}
\title{Distances between topic models (chains)}
\usage{
chainsDistances(
  x,
  method = c("euclidean", "hellinger", "cosine", "minMax", "naiveEuclidean",
    "invariantEuclidean"),
  ...
)
}
\arguments{
\item{x}{a valid \code{multiChains} object, obtained through the estimation of a
topic model using \code{\link[=fit.sentopicmodel]{fit()}} and the argument
\code{nChains} greater than \code{1}.}

\item{method}{the method used to measure the distance between chains.}

\item{...}{further arguments passed to internal distance functions.}
}
\value{
A matrix of distance between the elements of \code{x}
}
\description{
Computes the distance between different estimates of a topic
model. Since the estimation of a topic model is random, the results may
largely differ as the process is repeated. This function allows to compute
the distance between distinct realizations of the estimation process.
Estimates are referred to as \emph{chains}.
}
\details{
The \code{method} argument determines how are computed distance.
\itemize{
\item \code{euclidean} finds the pairs of topics that minimizes and returns the total
Euclidean distance.
\item \code{hellinger} does the same but based on the Hellinger distance.
\item \code{cosine} does the same but based on the Cosine distance.
\item \code{minMax} computes the maximum distance among the best pairs of distances.
Inspired by the \emph{minimum-matching distance} from Tang et al. (2014).
\item \code{naiveEuclidean} computes the Euclidean distance without searching for the
best pairs of topics.
\item \code{invariantEuclidean} computes the best pairs of topics for all allowed
permutations of topic indices. For JST and reversed-JST models, the two-
levels hierarchy of document-sentiment-topic leads some permutations of
indices to represent a drastically different outcome. This setting restricts
the set of permutations to the ones that do not change the interpretation of
the model. Equivalent to \code{euclidean} for LDA models.
}
}
\examples{
model <- LDA(ECB_press_conferences_tokens)
model <- fit(model, 10, nChains = 5)
chainsDistances(model)

}
\references{
Tang, J., Meng, Z., Nguyen, X., Mei, Q., and Zhang, M. (2014).
\href{https://proceedings.mlr.press/v32/tang14.html}{Understanding the Limiting Factors of Topic Modeling via Posterior Contraction Analysis}. In
\emph{Proceedings of the 31st International Conference on Machine Learning}, 32,
90--198.
}
\seealso{
\code{\link[=plot.multiChains]{plot.multiChains()}} \code{\link[=chainsScores]{chainsScores()}}
}
\author{
Olivier Delmarcelle
}
