% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object_Utilities.R
\name{Meta_Remove_Seurat}
\alias{Meta_Remove_Seurat}
\title{Remove meta data columns containing Seurat Defaults}
\usage{
Meta_Remove_Seurat(
  meta_data,
  seurat_object,
  barcodes_to_rownames = FALSE,
  barcodes_colname = "barcodes"
)
}
\arguments{
\item{meta_data}{data.frame containing meta data.}

\item{seurat_object}{object name.}

\item{barcodes_to_rownames}{logical, are barcodes present as column and should they be moved to
rownames (to be compatible with \code{Seurat::AddMetaData}).  Default is FALSE.}

\item{barcodes_colname}{name of barcodes column in meta_data.  Required if \code{barcodes_to_rownames = TRUE}.}
}
\value{
data.frame with only new columns.
}
\description{
Remove any columns from new meta_data data.frame in preparation for adding back to Seurat Object
}
\examples{
\dontrun{
new_meta <- Meta_Remove_Seurat(meta_data = meta_data_df, seurat_object = object)
object <- AddMetaData(object = object, metadata = new_meta)
}

}
\concept{get_set_util}
