% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Cells.liger}
\alias{Cells.liger}
\title{Extract Cells from LIGER Object}
\usage{
\method{Cells}{liger}(x, by_dataset = FALSE, ...)
}
\arguments{
\item{x}{LIGER object name.}

\item{by_dataset}{logical, whether to return list with vector of cell barcodes for each
dataset in LIGER object or to return single vector of cell barcodes across all
datasets in object (default is FALSE; return vector of cells).}

\item{...}{Arguments passed to other methods}
}
\value{
vector or list depending on \code{by_dataset} parameter
}
\description{
Extract all cell barcodes from LIGER object
}
\examples{
\dontrun{
# return single vector of all cells
all_features <- Cells(x = object, by_dataset = FALSE)

# return list of vectors containing cells from each individual dataset in object
dataset_features <- Cells(x = object, by_dataset = TRUE)
}

}
\concept{liger_object_util}
