% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Plotting.R
\name{Factor_Cor_Plot}
\alias{Factor_Cor_Plot}
\title{Factor Correlation Plot}
\usage{
Factor_Cor_Plot(
  object,
  colors_use = NULL,
  label = FALSE,
  label_threshold = 0.5,
  label_size = 5,
  plot_title = NULL,
  plot_type = "full",
  positive_only = FALSE,
  x_lab_rotate = TRUE,
  cluster = TRUE,
  cluster_rect = FALSE,
  cluster_rect_num = NULL,
  cluster_rect_col = NULL
)
}
\arguments{
\item{object}{liger or Seurat object.}

\item{colors_use}{Color palette to use for correlation values.
Default is \code{RColorBrewer::RdBu} if \code{positive_only = FALSE}.
If \code{positive_only = TRUE} the default is \code{viridis}.
Users can also supply vector of 3 colors (low, mid, high).}

\item{label}{logical, whether to add correlation values to plot result.}

\item{label_threshold}{threshold for adding correlation values if \code{label = TRUE}.  Default
is 0.5.}

\item{label_size}{size of correlation labels}

\item{plot_title}{Plot title.}

\item{plot_type}{Controls plotting full matrix, or just the upper or lower triangles.
Accepted values are: "full" (default), "upper", or "lower".}

\item{positive_only}{logical, whether to limit the plotted values to only positive
correlations (negative values set to 0); default is FALSE.}

\item{x_lab_rotate}{logical, whether to rotate the axes labels on the x-axis.  Default is TRUE.}

\item{cluster}{logical, whether to cluster the plot using \code{hclust} (default TRUE).  If FALSE
factors are listed in numerical order.}

\item{cluster_rect}{logical, whether to add rectangles around the clustered areas on plot,
default is FALSE.}

\item{cluster_rect_num}{number of rectangles to add to the plot, default NULL.}

\item{cluster_rect_col}{color to use for rectangles, default MULL (will set color automatically).}
}
\value{
A ggplot object
}
\description{
Plot positive correlations between gene loadings across \code{W} factor matrix in liger or
feature loadings in reduction slot of Seurat object.
Any negative correlations are set to NA and NA values set to bottom color of color gradient.
}
\examples{
\dontrun{
Factor_Cor_Plot(object = obj)
}

}
\concept{liger_plotting}
