% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMatrix.R
\name{PlotMatrix}
\alias{PlotMatrix}
\title{Function to convert any numerical table to a grid of coloured squares.}
\usage{
PlotMatrix(
  var,
  brks = NULL,
  cols = NULL,
  toptitle = NULL,
  title.color = "royalblue4",
  xtitle = NULL,
  ytitle = NULL,
  xlabels = NULL,
  xvert = FALSE,
  ylabels = NULL,
  line = 3,
  figure.width = 1,
  legend = TRUE,
  legend.width = 0.15,
  xlab_dist = NULL,
  ylab_dist = NULL,
  fileout = NULL,
  size_units = "px",
  res = 100,
  ...
)
}
\arguments{
\item{var}{A numerical matrix containing the values to be displayed in a 
colored image.}

\item{brks}{A vector of the color bar intervals. The length must be one more 
than the parameter 'cols'. Use ColorBar() to generate default values.}

\item{cols}{A vector of valid color identifiers for color bar. The length
must be one less than the parameter 'brks'. Use ColorBar() to generate 
default values.}

\item{toptitle}{A string of the title of the grid. Set NULL as default.}

\item{title.color}{A string of valid color identifier to decide the title 
color. Set "royalblue4" as default.}

\item{xtitle}{A string of title of the x-axis. Set NULL as default.}

\item{ytitle}{A string of title of the y-axis. Set NULL as default.}

\item{xlabels}{A vector of labels of the x-axis. The length must be 
length of the column of parameter 'var'. Set the sequence from 1 to the 
length of the column of parameter 'var' as default.}

\item{xvert}{A logical value to decide whether to place x-axis labels 
vertically. Set FALSE as default, which keeps the labels horizontally.}

\item{ylabels}{A vector of labels of the y-axis The length must be 
length of the row of parameter 'var'. Set the sequence from 1 to the 
length of the row of parameter 'var' as default.}

\item{line}{An integer specifying the distance between the title of the 
x-axis and the x-axis. Set 3 as default. Adjust if the x-axis labels 
are long.}

\item{figure.width}{A positive number as a ratio adjusting the width of the 
grids. Set 1 as default.}

\item{legend}{A logical value to decide to draw the grid color legend or not. 
Set TRUE as default.}

\item{legend.width}{A number between 0 and 0.5 to adjust the legend width.
Set 0.15 as default.}

\item{xlab_dist}{A number specifying the distance between the x labels and 
the x axis. If not specified, it equals to -1 - (nrow(var) / 10 - 1).}

\item{ylab_dist}{A number specifying the distance between the y labels and 
the y axis. If not specified, it equals to 0.5 - ncol(var) / 10.}

\item{fileout}{A string of full directory path and file name indicating where 
to save the plot. If not specified (default), a graphics device will pop up.}

\item{size_units}{A string indicating the units of the size of the device 
(file or window) to plot in. Set 'px' as default. See ?Devices and the 
creator function of the corresponding device.}

\item{res}{A positive number indicating resolution of the device (file or window) 
to plot in. See ?Devices and the creator function of the corresponding device.}

\item{...}{The additional parameters to be passed to function ColorBar() in 
s2dv for color legend creation.}
}
\value{
A figure in popup window by default, or saved to the specified path.
}
\description{
This function converts a numerical data matrix into a coloured 
grid. It is useful for a slide or article to present tabular results as 
colors instead of numbers.
}
\examples{
# Example with random data
PlotMatrix(var = matrix(rnorm(n = 120, mean = 0.3), 10, 12),
           cols = c('white','#fef0d9','#fdd49e','#fdbb84','#fc8d59',
                      '#e34a33','#b30000', '#7f0000'),
           brks = c(-1, 0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 1),
           toptitle = "Mean Absolute Error", 
           xtitle = "Forecast time (month)", ytitle = "Start date",
           xlabels = c("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", 
                       "Aug", "Sep", "Oct", "Nov", "Dec"))

}
