% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_continuous_force.R
\name{prepare_continuous_force}
\alias{prepare_continuous_force}
\title{Prepare continuous features for embedding}
\usage{
prepare_continuous_force(
  g,
  node_names,
  k = NULL,
  force_var,
  sum_to_one = TRUE,
  distance = 1
)
}
\arguments{
\item{g}{an igraph object}

\item{node_names}{a character string. A vertex attribute which contains the node names.}

\item{k}{The spring constant. This value is either a numeric value giving the spring constant for all edges or NULL. If NULL is used 
the k value will not be added to the network. This is useful k is made through some other process.}

\item{force_var}{A character vector. This is the vector of node attributes to be used as the force variables.
All the attributes must be a numeric or integer value, and cannot have NA's. On a single variable embedding this is usually "force"}

\item{sum_to_one}{Logical. whether the total positive force sums to 1, if FALSE the total is the sum of the positive cases}

\item{distance}{a positive numeric value. The default is 1}
}
\value{
A network with the correct edge and node attributes for the embeddings process.
}
\description{
This function prepares a continuous network for SETSe projection. The function works for networks with a single feature or
high-dimensional features.
The network takes in an igraph object and produces an undirected igraph object that can be used with the embedding functions.
}
\details{
The function subtracts the mean from all the values so that the system is balanced. If sum_to_one is true then everything is divided by
 the absolute sum over two 
 
 The function adds the node attribute 'force' and the edge attribute 'k' unless k=NULL. The purpose of the function is to easily be able to 
 project continuous networks using SETSe. 
 
 The function creates several variables
\itemize{
  \item force: a vertex attribute representing the force produced by each node. The sum of this variable will be 0
  \item k: The spring constant representing the stiffness of the spring. 
  \item edge_name: the name of the edges. it takes the form "from_to" where "from" is the origin node and "to" is the destination node using the 
 \link[igraph]{as_data_frame} function from igraph
}
}
\examples{
embeddings <- biconnected_network \%>\%
#prepare the network for a binary embedding
#k is already present in the data so is left null in the preparation function
prepare_edges(k = NULL, distance = 1) \%>\%
prepare_continuous_force(., node_names = "name", force_var = "force") \%>\%
#embed the network using auto_setse
#in the biconnected_network dataset the edge weights are used directly as k values
setse_auto(k = "weight")
}
\seealso{
\link{setse_auto_hd}

Other prepare_setse: 
\code{\link{prepare_categorical_force}()},
\code{\link{prepare_edges}()}
}
\concept{prepare_setse}
