% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design_power_and_asn.R
\name{PowerAndAverageSampleNumberResult}
\alias{PowerAndAverageSampleNumberResult}
\title{Power and Average Sample Number Result}
\description{
Class for power and average sample number (ASN) results.
}
\details{
This object cannot be created directly;
use \code{\link[=getPowerAndAverageSampleNumber]{getPowerAndAverageSampleNumber()}}
with suitable arguments to create it.
}
\section{Fields}{

\describe{
\item{\code{nMax}}{The maximum sample size. Is a numeric vector of length 1 containing a whole number.}

\item{\code{theta}}{A vector of standardized effect sizes (theta values). Is a numeric vector.}

\item{\code{averageSampleNumber}}{The average sample number calculated for each value of \code{theta} or \code{nMax}, if the specified maximum sample size would be exceeded. Is a numeric vector.}

\item{\code{calculatedPower}}{The calculated power for the given scenario.}

\item{\code{overallEarlyStop}}{The overall early stopping probability. Is a numeric vector.}

\item{\code{earlyStop}}{The probability to stopping the trial either for efficacy or futility. Is a numeric vector.}

\item{\code{overallReject}}{The overall rejection probability. Is a numeric vector.}

\item{\code{rejectPerStage}}{The probability to reject a hypothesis per stage of the trial. Is a numeric matrix.}

\item{\code{overallFutility}}{The overall stopping for futility probability. Is a numeric vector.}

\item{\code{futilityPerStage}}{The per-stage probabilities of stopping the trial for futility. Is a numeric matrix.}
}}

\keyword{internal}
