\name{workplace}
\alias{workplace}
\docType{data}
\title{(Modified) Canadian Workplace and Employee Survey}
\description{
    The \code{workplace} data are from Fuller (2009, pp. 366--367).
}
\usage{data(workplace)}
\format{
    A \code{data.frame} with a sample of 142 workplaces on the following
    variables
    \describe{
        \item{\code{ID}}{identifier variable \code{[integer]}.}
        \item{\code{weight}}{sampling weight \code{[double]}.}
        \item{\code{employment}}{employment total \code{[double]}.}
        \item{\code{payroll}}{payroll total (1000 dollars)\code{[double]}.}
        \item{\code{strat}}{stratum identifier\code{[integer]}.}
        \item{\code{fpc}}{finite population correction \code{[integer]}.}
    }
}
\details{
    The \code{workplace} data represent a sample of workplaces in the
    retail sector in a Canadian province. The data are \emph{not} those
    collected by Statistics Canada, but have been generated by Fuller
    (2009, Example 3.1.1) to display similar characteristics to the
    original 1999 Canadian Workplace and Employee Survey (WES).

    \subsection{Sampling design of the 1999 WES}{
    The WES target population is defined as all workplaces operating in
    Canada with paid employees. The sampling frame is stratified by
    industry, geographic region, and size (size is defined using
    estimated employment). A sample of workplaces has been drawn
    independently in each stratum using simple random sample without
    replacement (the stratum-specific sample sizes are determined
    by Neyman allocation).
    Several strata containing very large workplaces were sampled
    exhaustively; see Patak et al (1998). The original sampling weights
    were adjusted for nonresponse.
}

\subsection{Remarks by Fuller (2009, p. 365)}{The original weights of WES
    were about 2200 for the stratum of small workplaces, about 750 for
    medium-sized, and about 35 for large workspaces.}
}
\source{
The data \code{workplace} is from Table 6.3 in Fuller (2009, pp. 366--367).
}
\references{
Fuller, W. A. (2009). \emph{Sampling Statistics},
    Hoboken (NJ): John Wiley and Sons.
    \doi{10.1002/9780470523551}

Patak, Z., Hidiroglou, M. and Lavallée, P. (1998). The methodology of the
    Workplace and Employee Survey. \emph{Proceedings of the Survey
    Research Methods Section, American Statistical Association}, 83--91.
}
\examples{
head(workplace)

library("survey")
# Survey design for stratified simple random sampling without replacement
dn <- if (packageVersion("survey") >= "4.2") {
        # survey design with pre-calibrated weights
        svydesign(ids = ~ID, strata = ~strat, fpc = ~fpc, weights = ~weight,
                  data = workplace, calibrate.formula = ~-1 + strat)
    } else {
        # legacy mode
        svydesign(ids = ~ID, strata = ~strat, fpc = ~fpc, weights = ~weight,
                  data = workplace)
    }
}
\keyword{datasets}
