% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{predict.NuggetKriging}
\alias{predict.NuggetKriging}
\title{Predict from a \code{NuggetKriging} object.}
\usage{
\method{predict}{NuggetKriging}(
  object,
  x,
  return_stdev = TRUE,
  return_cov = FALSE,
  return_deriv = FALSE,
  ...
)
}
\arguments{
\item{object}{S3 NuggetKriging object.}

\item{x}{Input points where the prediction must be computed.}

\item{return_stdev}{\code{Logical}. If \code{TRUE} the standard deviation
is returned.}

\item{return_cov}{\code{Logical}. If \code{TRUE} the covariance matrix of
the predictions is returned.}

\item{return_deriv}{\code{Logical}. If \code{TRUE} the derivatives of mean and sd
of the predictions are returned.}

\item{...}{Ignored.}
}
\value{
A list containing the element \code{mean} and possibly
    \code{stdev} and  \code{cov}.
}
\description{
Given "new" input points, the method compute the expectation,
variance and (optionnally) the covariance of the corresponding
stochastic process, conditional on the values at the input points
used when fitting the model.
}
\note{
The names of the formal arguments differ from those of the
    \code{predict} methods for the S4 classes \code{"km"} and
    \code{"KM"}. The formal \code{x} corresponds to
    \code{newdata}, \code{stdev} corresponds to \code{se.compute}
    and \code{cov} to \code{cov.compute}. These names are chosen
    \pkg{Python} and \pkg{Octave} interfaces to \pkg{libKriging}.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
plot(f)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))
points(X, y, col = "blue", pch = 16)

k <- NuggetKriging(y, X, "matern3_2")

## include design points to see interpolation
x <- sort(c(X,seq(from = 0, to = 1, length.out = 101)))
p <- predict(k, x)

lines(x, p$mean, col = "blue")
polygon(c(x, rev(x)), c(p$mean - 2 * p$stdev, rev(p$mean + 2 * p$stdev)),
 border = NA, col = rgb(0, 0, 1, 0.2))
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
