% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_crisk.R
\name{plot_crisk}
\alias{plot_crisk}
\title{Plot a cumulative risk curve.}
\usage{
plot_crisk(
  x,
  y = NULL,
  x_from = NA,
  x_to = NA,
  fit_curve = FALSE,
  show_pas = FALSE,
  show_rem = FALSE,
  show_pop = FALSE,
  show_aux = FALSE,
  show_num = FALSE,
  show_inc = FALSE,
  show_grid = FALSE,
  col_pal = pal_crisk,
  arr_c = -3,
  main = txt$scen_lbl,
  sub = "type",
  title_lbl = NULL,
  x_lbl = "Age (in years)",
  y_lbl = "Population risk",
  y2_lbl = "",
  mar_notes = FALSE,
  ...
)
}
\arguments{
\item{x}{Data or values of an x-dimension on which risk is expressed
(required).
If \code{x} but not \code{y} is provided,
\code{\link{xy.coords}} from \strong{grDevices}
is used to determine \code{x}- and \code{y}-values.}

\item{y}{Values of cumulative risks on a y-dimension
(optional, if \code{x} is an appropriate structure),
as monotonically increasing percentage values
(ranging from 0 to 100).
Default: \code{y = NULL}.}

\item{x_from}{Start value of risk increment.
Default: \code{x_from = NA}.}

\item{x_to}{End value of risk increment.
Default: \code{x_to = NA}.}

\item{fit_curve}{Boolean: Fit a curve to \code{x}-\code{y}-data?
Default: \code{fit_curve = FALSE}.}

\item{show_pas}{Boolean: Show past/passed risk?
Default: \code{show_pas = FALSE}.}

\item{show_rem}{Boolean: Show remaining risk?
Default: \code{show_rem = FALSE}.}

\item{show_pop}{Boolean: Show population partitions?
Default: \code{show_pop = FALSE}.}

\item{show_aux}{Boolean: Show auxiliary elements
(i.e., explanatory lines, points, and labels)?
Default: \code{show_aux = FALSE}.}

\item{show_num}{Boolean: Show numeric values,
provided that \code{show_aux = TRUE}.
Default: \code{show_num = FALSE}.}

\item{show_inc}{Boolean: Show risk increments?
Default: \code{show_inc = FALSE}.}

\item{show_grid}{Boolean: Show grid lines?
Default: \code{show_grid = FALSE}.}

\item{col_pal}{Color palette (as a named vector).
Default: \code{col_pal = \link{pal_crisk}}.}

\item{arr_c}{Arrow code for symbols at ends of population links
(as a numeric value \code{-3 <= arr_c <= +6}),
with the following options:
  \itemize{
  \item \code{-1} to \code{-3}: points at one/other/both end/s;
  \item \code{0}: no symbols;
  \item \code{+1} to \code{+3}: V-arrow at one/other/both end/s;
  \item \code{+4} to \code{+6}: T-arrow at one/other/both end/s.
}
Default: \code{arr_c = -3} (points at both ends).}

\item{main}{Text label for main plot title.
Default: \code{main = txt$scen_lbl}.}

\item{sub}{Text label for plot subtitle (on 2nd line).
Default: \code{sub = "type"} shows information on current plot type.}

\item{title_lbl}{\strong{Deprecated} text label for current plot title.
Replaced by \code{main}.}

\item{x_lbl}{Text label of x-axis (at bottom).
Default: \code{x_lbl = "Age (in years)"}.}

\item{y_lbl}{Text label of y-axis (on left).
Default: \code{y_lbl = "Population risk"}.}

\item{y2_lbl}{Text label of 2nd y-axis (on right).
Default: \code{y2_lbl = ""} (formerly "Remaining risk").}

\item{mar_notes}{Boolean option for showing margin notes.
Default: \code{mar_notes = FALSE}.}

\item{...}{Other (graphical) parameters.}
}
\value{
Nothing (NULL).
}
\description{
\code{plot_crisk} creates visualizations of cumulative risks.
}
\details{
\code{plot_crisk} assumes data inputs \code{x} and \code{y}
that correspond to each other so that \code{y} is a
(monotonically increasing) probability density function
(over cumulative risk amounts represented by \code{y}
as a function of \code{x}).

Inputs to \code{x} and \code{y} must typically be of the same length.
If \code{x} but not \code{y} is provided,
\code{\link{xy.coords}} from \strong{grDevices}
is used to determine \code{x}- and \code{y}-values.

The risk events quantified by the cumulative risk values in \code{y}
are assumed to be uni-directional, non-reversible, and
expressed as percentages (ranging from 0 to 100).
Thus, an element in the population can only switch its status once
(from 'unaffected' to 'affected' by the risk factor).

A cumulative risk increment is computed for
an interval ranging from \code{x_from} to \code{x_to}.
If risk values for \code{x_from} or \code{x_to} are not provided
(i.e., in \code{x} and \code{y}),
a curve is fitted to predict \code{y} by \code{x}
(by \code{fit_curve = TRUE}).

Note that naive interpretations allow for both
overestimation (e.g., reading off population values)
and underestimation (e.g., reading off future risk increases without
re-scaling to remaining population).

For instructional purposes, \code{plot_crisk} provides
options for showing/hiding various elements required
for computing or comprehending cumulative risk increments.

Color information is based on a vector with named
colors \code{col_pal = \link{pal_crisk}}.
}
\examples{
# Data:
x <- seq(0, 100, by = 10)
y <- c(0, 0, 0, 8, 24, 50, 70, 80, 83, 85, 85)

# Basic versions:
plot_crisk(x, y)  # using data provided
plot_crisk(x, y, x_from = 40)  # use and mark 1 provided point
plot_crisk(x, y, x_from = 44)  # use and mark 1 predicted point
plot_crisk(x, y, x_from = 40, x_to = 60)  # use 2 provided points
plot_crisk(x, y, x_from = 44, x_to = 64)  # use 2 predicted points
plot_crisk(x, y, fit_curve = TRUE)  # fitting curve to provided data

# Training versions:
plot_crisk(x, y, 44, 64, show_pas = TRUE)  # past/passed risk only
plot_crisk(x, y, 44, 64, show_rem = TRUE)  # remaining risk only
plot_crisk(x, y, 44, 64, show_pas = TRUE, show_rem = TRUE) # both risks
plot_crisk(x, y, 44, 64, show_aux = TRUE)  # auxiliary lines + axis
plot_crisk(x, y, 44, 64, show_aux = TRUE, show_pop = TRUE)  # + population parts
plot_crisk(x, y, 44, 64, show_aux = TRUE, show_num = TRUE)  # + numeric values
plot_crisk(x, y, 44, 85, show_aux = TRUE, show_pop = TRUE, show_num = TRUE) # + aux/pop/num

# Note: Showing ALL is likely to overplot/overwhelm:
plot_crisk(x, y, x_from = 47, x_to = 67, fit_curve = TRUE,
           main = "The main title", sub = "Some subtitle",
           show_pas = TRUE, show_rem = TRUE, show_aux = TRUE, show_pop = TRUE,
           show_num = TRUE, show_inc = TRUE, show_grid = TRUE, mar_notes = TRUE)

# Small x- and y-values and linear increases:
plot_crisk(x = 2:10, y = seq(12, 28, by = 2), x_from = 4.5, x_to = 8.5,
           show_pas = TRUE, show_rem = TRUE, show_aux = TRUE, show_pop = TRUE,
           show_num = TRUE, show_inc = TRUE)

}
\seealso{
\code{\link{pal_crisk}} corresponding color palette.

Other visualization functions: 
\code{\link{plot.riskyr}()},
\code{\link{plot_area}()},
\code{\link{plot_bar}()},
\code{\link{plot_curve}()},
\code{\link{plot_fnet}()},
\code{\link{plot_icons}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_plane}()},
\code{\link{plot_prism}()},
\code{\link{plot_tab}()},
\code{\link{plot_tree}()}
}
\concept{visualization functions}
