% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveCoxConfidential.R
\name{saveCoxConfidential}
\alias{saveCoxConfidential}
\title{Save confidential Cox objects}
\usage{
saveCoxConfidential(object, times)
}
\arguments{
\item{object}{An object of class \code{coxph}.}

\item{times}{The times at which we want to predict risk.}
}
\description{
Save confidential Cox objects
}
\details{
This function can save \code{coxph} objects such that we do not need to export 
the data on which it was fitted at given times.
}
\examples{
library(survival)
library(lava)
set.seed(18)
trainSurv <- sampleData(300,outcome="survival")
testSurv <- sampleData(40,outcome="survival")
fit = coxph(Surv(time,event)~X1+X2+X3+X7+X9,data=trainSurv, y=TRUE, x = TRUE)
u=saveCoxConfidential(fit,times=3)
\dontrun{
# write object as plain text file
sink("~/tmp/u.R")
cat("U <- ")
dput(u)
sink(NULL)
# reload object
source("~/tmp/u.R")
class(u) <- "CoxConfidential"
}
predictRisk(u,newdata=testSurv)
cox1 = coxph(Surv(time,event)~strata(X1)+X2+X3+X7+X9,data=trainSurv, y=TRUE, x = TRUE)
z<-saveCoxConfidential(cox1,c(2,5))

dput(z) ## get output to copy object

all.equal(predictRisk(z,newdata=testSurv),
          predictRisk(cox1,newdata=testSurv,times=c(2,5)))

cox2 = coxph(Surv(time,event)~X1+X2+X7+X9,data=trainSurv, y=TRUE, x = TRUE)
z<-saveCoxConfidential(cox2,c(2,5))

all.equal(predictRisk(z,testSurv),predictRisk(z,testSurv,c(2,5)))
}
