% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.tables.ate.R
\name{model.tables.ate}
\alias{model.tables.ate}
\title{Statistical Inference for the Average Treatment Effect}
\usage{
\method{model.tables}{ate}(
  x,
  contrasts = NULL,
  times = NULL,
  estimator = NULL,
  type = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{ate} object, i.e. output of the \code{ate} function.}

\item{contrasts}{[character vector] levels of the treatment variable for which the estimates should be assessed or compared. Default is to consider all levels.}

\item{times}{[numeric vector] The timepoints at which the estimates should be displayed. Default is to consider all timepoints.}

\item{estimator}{[character] The type of estimator relative to which the estimates should be displayed.}

\item{type}{[character] should the average risk per treatment be displayed (\code{"meanRisk"}),
or the difference in average risk between any two pairs of treatments (\code{"diffRisk"}),
or the ratio in average risk between any two pairs of treatments (\code{"ratioRisk"}).}

\item{...}{Additional arguments (meanRisk.transform, ..., method.band, ...) passed to \code{\link{confint.ate}}.}
}
\value{
a data.frame.
}
\description{
Export estimated average treatment effects with their uncertainty (standard errors, confidence intervals and p-values).
}
\author{
Brice Ozenne \email{broz@sund.ku.dk}
}
