% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dta.R
\name{read_dta}
\alias{read_dta}
\title{Read Stata DTA files (`.dta`) files}
\usage{
read_dta(file, id = NULL, doi = NULL, .name_repair = "unique")
}
\arguments{
\item{file}{A STATA file.}

\item{id}{An identifier of the tibble, if omitted, defaults to the
file name without its extension.}

\item{doi}{An optional document object identifier.}

\item{.name_repair}{Defaults to \code{"unique"} See
\code{tibble::\link[tibble:as_tibble]{as_tibble}} for details.}
}
\value{
A tibble.

  Variable labels are stored in the "label" attribute of each variable.
  It is not printed on the console, but the RStudio viewer will show it.

  `write_sav()` returns the input `data` invisibly.
}
\description{
This is a wrapper around \code{haven::\link[haven:read_dta]{read_dta}}
with some exception handling.
}
\details{
`read_dta()` reads both `.dta`  files.

The funcion is not yet tested.
}
\examples{
\donttest{
path <- system.file("examples", "iris.dta", package = "haven")
read_dta(path)
}
}
\seealso{
Other import functions: 
\code{\link{harmonize_survey_variables}()},
\code{\link{pull_survey}()},
\code{\link{read_csv}()},
\code{\link{read_rds}()},
\code{\link{read_spss}()},
\code{\link{read_surveys}()}
}
\concept{import functions}
