% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_shortburst.R
\name{redist_shortburst}
\alias{redist_shortburst}
\title{Redistricting Optimization through Short Bursts}
\usage{
redist_shortburst(
  map,
  score_fn = NULL,
  stop_at = NULL,
  burst_size = ifelse(backend == "mergesplit", 10L, 50L),
  max_bursts = 500L,
  maximize = TRUE,
  init_plan = NULL,
  counties = NULL,
  constraints = redist_constr(map),
  compactness = 1,
  adapt_k_thresh = 0.95,
  reversible = TRUE,
  fixed_k = NULL,
  return_all = TRUE,
  thin = 1L,
  backend = "mergesplit",
  flip_lambda = 0,
  flip_eprob = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{map}{A \link{redist_map} object.}

\item{score_fn}{A function which takes a matrix of plans and returns a score
(or, generally, a row vector) for each plan. Can also be a purrr-style
anonymous function. See \code{\link[=scorers]{?scorers}} for some function factories
for common scoring rules.}

\item{stop_at}{A threshold to stop optimization at. When \code{score_fn} returns a
row vector per plan, \code{maximize} can be an equal-length vector specifying a
threshold for each dimension, which must all be met for the algorithm to
stop.}

\item{burst_size}{The size of each burst. 10 is recommended for the
\code{mergesplit} backend and 50 for the \code{flip} backend. Can also provide
burst schedule function which takes the current iteration (an integer)
and returns the desired burst size. This can be a random function.}

\item{max_bursts}{The maximum number of bursts to run before returning.}

\item{maximize}{If \code{TRUE}, try to maximize the score; otherwise, try to
minimize it. When \code{score_fn} returns a row vector per plan, \code{maximize} can
be an equal-length vector specifying whether each dimension should be
maximized or minimized.}

\item{init_plan}{The initial state of the map. If not provided, will default to
the reference map of the \code{map} object, or if none exists, will sample
a random initial state using \code{\link[=redist_smc]{redist_smc()}}. You can also request
a random initial state by setting \code{init_plan="sample"}.}

\item{counties}{A vector containing county (or other administrative or
geographic unit) labels for each unit, which may be integers ranging from 1
to the number of counties, or a factor or character vector.  If provided, the
algorithm will only generate maps which split up to \code{ndists-1} counties.
If no county-split constraint is desired, this parameter should be left blank.}

\item{constraints}{A \code{redist_constr} with Gibbs constraints.}

\item{compactness}{Controls the compactness of the generated districts, with
higher values preferring more compact districts. Must be non-negative. See
\code{\link{redist_mergesplit}} for more information.}

\item{adapt_k_thresh}{The threshold value used in the heuristic to select a
value \code{k_i} for each splitting iteration.}

\item{reversible}{If \code{FALSE} and \code{backend="mergesplit"}, the Markov chain
used will not be reversible. This may speed up optimization.}

\item{fixed_k}{If not \code{NULL}, will be used to set the \code{k} parameter for the
\code{mergesplit} backend. If e.g. \code{k=1} then the best edge in each spanning
tree will be used.  Lower values may speed up optimization at the
cost of the Markov chain no longer targeting a known distribution.
Recommended only in conjunction with \code{reversible=FALSE}.}

\item{return_all}{Whether to return all the burst results or just the best
one (generally, the Pareto frontier). Recommended for monitoring purposes.}

\item{thin}{Save every \code{thin}-th sample. Defaults to no thinning (1). Ignored
if \code{return_all=TRUE}.}

\item{backend}{the MCMC algorithm to use within each burst, either
"mergesplit" or "flip".}

\item{flip_lambda}{The parameter determining the number of swaps to attempt each iteration of flip mcmc.
The number of swaps each iteration is equal to Pois(lambda) + 1. The default is 0.}

\item{flip_eprob}{The probability of keeping an edge connected in flip mcmc. The default is 0.05.}

\item{verbose}{Whether to print out intermediate information while sampling.
Recommended for monitoring purposes.}
}
\value{
a \code{redist_plans} object containing the final best plan
(or the best plans after each burst, if \code{return_all=TRUE}.
}
\description{
This function uses \code{\link[=redist_mergesplit]{redist_mergesplit()}} or \code{\link[=redist_flip]{redist_flip()}} to optimize a
redistrict plan according to a user-provided criteria. It does so by running
the Markov chain for "short bursts" of usually 10 iterations, and then
starting the chain anew from the best plan in the burst, according to the
criteria. This implements the ideas in the below-referenced paper, "Voting
Rights, Markov Chains, and Optimization by Short Bursts."
}
\examples{
\donttest{
data(iowa)

iowa_map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.01)
redist_shortburst(iowa_map, scorer_frac_kept(iowa_map), max_bursts = 50)
redist_shortburst(iowa_map, ~ 1 - scorer_frac_kept(iowa_map)(.), max_bursts = 50)
}

}
\references{
Cannon, S., Goldbloom-Helzner, A., Gupta, V., Matthews, J. N., & Suwal, B.
(2020). Voting Rights, Markov Chains, and Optimization by Short Bursts. arXiv
preprint arXiv:2011.02288.
}
\concept{simulate}
