% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{osmdata_as_sf}
\alias{osmdata_as_sf}
\title{Retrieve OpenStreetMap data as sf object}
\usage{
osmdata_as_sf(key, value, aoi, force_download = FALSE)
}
\arguments{
\item{key}{A case-insensitive character vector of length 1 with the key to
filter the data}

\item{value}{A case-insensitive character vector with the value(s) to filter
the data}

\item{aoi}{An area of interest, provided either as as sf object or "bbox" or
as a vector ("xmin", "ymin", "xmax", "ymax")}

\item{force_download}{Download data even if cached data is available}
}
\value{
An \code{\link[osmdata:osmdata]{osmdata::osmdata}} object with the retrieved OpenStreetMap data
}
\description{
Query the Overpass API for a key:value pair within a given bounding box
(provided as lat/lon coordiates). Results are cached, so that new queries
with the same input parameters will be loaded from disk.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
osmdata_as_sf(key = "highway",
              value = "motorway",
              aoi = bb,
              force_download = FALSE)
\dontshow{\}) # examplesIf}
}
