% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rEHR_functions.R
\name{connect_database}
\alias{connect_database}
\title{Open connection to SQLite database}
\usage{
connect_database(dbname)
}
\arguments{
\item{dbname}{Name of SQLite database on hard disk (including full file path relative to working directory)}
}
\value{
No return value, called to open a database connection.
}
\description{
Open connection to SQLite database
}
\examples{

## Connect to a database
aurum_extract <- connect_database(file.path(tempdir(), "temp.sqlite"))

## Check connection is open
inherits(aurum_extract, "DBIConnection")

## clean up
RSQLite::dbDisconnect(aurum_extract)
unlink(file.path(tempdir(), "temp.sqlite"))

}
