% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dockerfile.R
\name{add_dockerfile}
\alias{add_dockerfile}
\title{Create a Dockerfile}
\usage{
add_dockerfile(
  given = NULL,
  family = NULL,
  email = NULL,
  open = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{given}{A character of length 1. The given name of the project
maintainer.}

\item{family}{A character of length 1. The family name of the project
maintainer.}

\item{email}{A character of length 1. The email address of the project
maintainer.}

\item{open}{A logical value. If \code{TRUE} (default) the \code{Dockerfile} is opened
in the editor.}

\item{overwrite}{A logical value. If this file is already present and
\code{overwrite = TRUE}, it will be erased and replaced. Default is \code{FALSE}.}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
No return value.
}
\description{
This function creates a \code{Dockerfile} at the root of the project based on a
template. The Docker image is based on
\href{https://hub.docker.com/r/rocker/rstudio}{rocker/rstudio}. The whole project
will be copied in the image and R packages will be installed (using
\code{\link[renv:restore]{renv::restore()}} or \code{\link[remotes:install_deps]{remotes::install_deps()}}).

In addition a \code{.dockerignore} file is added to ignore some files/folders
while building the image.

User can customize this \code{Dockerfile} (e.g. system dependencies). He/she
can also use a different default Docker image (i.e. \code{tidyverse}, \code{verse},
\code{geospatial}, etc.). For more information:
https://github.com/rocker-org/rocker-versioned2

By default the versions of R and \code{renv} (if applicable) specified in the
\code{Dockerfile} are the same as the local system.

Once the project is ready to be released, user must build the Docker image by
running: \verb{docker build -t "image_name" .}

Then to run a container, user must run:
\verb{docker run --rm -p 127.0.0.1:8787:8787 -e DISABLE_AUTH=true image_name}

A new instance of RStudio Server is available on the Web browser at the URL:
\verb{127.0.0.1:8787}.
}
\examples{
\dontrun{
add_dockerfile()
}
}
\seealso{
Other create files: 
\code{\link{add_citation}()},
\code{\link{add_code_of_conduct}()},
\code{\link{add_compendium}()},
\code{\link{add_contributing}()},
\code{\link{add_description}()},
\code{\link{add_license}()},
\code{\link{add_makefile}()},
\code{\link{add_package_doc}()},
\code{\link{add_readme_rmd}()},
\code{\link{add_renv}()},
\code{\link{add_testthat}()},
\code{\link{add_vignette}()}
}
\concept{create files}
