% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rcdf_as.R
\name{write_rcdf_dta}
\alias{write_rcdf_dta}
\title{Write RCDF data to Stata `.dta` files}
\usage{
write_rcdf_dta(data, path, ..., parent_dir = NULL)
}
\arguments{
\item{data}{A valid RCDF object.}

\item{path}{Output directory for files.}

\item{...}{Additional arguments passed to `foreign::write.dta()`.}

\item{parent_dir}{Optional subdirectory under `path` to group Stata files.}
}
\value{
Invisibly returns `NULL`. Files are written to disk.
}
\description{
Writes each table in the RCDF object to a `.dta` file for use in Stata.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
temp_dir <- tempdir()

write_rcdf_dta(data = rcdf_data, path = temp_dir)

unlink(temp_dir, force = TRUE)
}
\seealso{
\link[rcdf]{write_rcdf_as}
}
