% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{make_rbmi_cluster}
\alias{make_rbmi_cluster}
\title{Create a \code{rbmi} ready cluster}
\usage{
make_rbmi_cluster(ncores = 1, objects = NULL, packages = NULL)
}
\arguments{
\item{ncores}{Number of parallel processes to use or an existing cluster to make use of}

\item{objects}{a named list of objects to export into the sub-processes}

\item{packages}{a character vector of libraries to load in the sub-processes

This function is a wrapper around \code{parallel::makePSOCKcluster()} but takes
care of configuring \code{rbmi} to be used in the sub-processes as well as loading
user defined objects and libraries and setting the seed for reproducibility.

If \code{ncores} is \code{1} this function will return \code{NULL}.

If \code{ncores} is a cluster created via \code{parallel::makeCluster()} then this function
just takes care of inserting the relevant \code{rbmi} objects into the existing cluster.}
}
\description{
Create a \code{rbmi} ready cluster
}
\examples{
\dontrun{
# Basic usage
make_rbmi_cluster(5)

# User objects + libraries
VALUE <- 5
myfun <- function(x) {
    x + day(VALUE) # From lubridate::day()
}
make_rbmi_cluster(5, list(VALUE = VALUE, myfun = myfun), c("lubridate"))

# Using a already created cluster
cl <- parallel::makeCluster(5)
make_rbmi_cluster(cl)
}
}
