% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-format.R
\name{fmt_table}
\alias{fmt_table}
\title{Center and Decimal Align Tables}
\usage{
fmt_table(
  df,
  dec_dig = 1,
  prop_dig = 3,
  corr_dig = 3,
  output = NULL,
  fmt_small = TRUE,
  max_value = NULL,
  keep_zero = FALSE
)
}
\arguments{
\item{df}{A data frame or tibble to be formatted for printing in output.}

\item{dec_dig}{The number of decimal places to include for numbers, e.g.,
\code{dec_dig = 1} for 16.5.}

\item{prop_dig}{The number of decimal places to include for numbers bounded
between [0,1], e.g., \code{prop_dig = 2} for .35.}

\item{corr_dig}{The number of decimal places to include for numbers bounded
between [-1,1], e.g., \code{corr_dig = 3} for .205.}

\item{output}{The output format of the table. One of "latex" or "html".
Automatically pulled from document output type if not specified.}

\item{fmt_small}{Indicator for replacing zero with \code{<} (e.g., \code{.000} becomes
\verb{<.001}). Default is \code{TRUE}.}

\item{max_value}{If \code{fmt_small} is \code{TRUE} and a \code{max_value} is supplied,
any value greater than the \code{max_value} is replaced with \code{>}
(e.g., if \code{max_value} = 50, then \code{60} becomes \verb{>49.9}). The number of digits
depends on either \code{dec_digits}, \code{prop_dig}, or \code{corr_dig}.}

\item{keep_zero}{If \code{fmt_small} is \code{TRUE}, whether to preserve true 0s (e.g.,
\code{0.0000001} becomes \verb{<.001}, but \code{0.0000000} stays \code{.000}).}
}
\value{
A tibble with the same rows and columns as \code{df}, with numbers
formatted consistently and padded for alignment when printed.
}
\description{
Automatic formatting for tables that should "just work" for most use cases.
For more fine-grained control, see \link{formatting} and
\link{padding}.
}
\examples{
pcts <- tibble::tibble(n = 0:5, p = 0.5 * (0:5))
pcts \%>\% fmt_table()
}
\seealso{
Other formatters: 
\code{\link{formatting}},
\code{\link{padding}}
}
\concept{formatters}
