% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prmap.R
\name{plot.prmap}
\alias{plot.prmap}
\title{Plot method for the prmap function}
\usage{
\method{plot}{prmap}(
  x,
  plots = "",
  scaling = 2,
  fontsz = 5,
  seed = 1234,
  shiny = FALSE,
  custom = FALSE,
  ...
)
}
\arguments{
\item{x}{Return value from \code{\link{prmap}}}

\item{plots}{Components to include in the plot ("brand", "attr"). If data on preferences is available use "pref" to add preference arrows to the plot}

\item{scaling}{Arrow scaling in the brand map}

\item{fontsz}{Font size to use in plots}

\item{seed}{Random seed}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{https://ggplot2.tidyverse.org/} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the prmap function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/prmap.html} for an example in Radiant
}
\examples{
result <- prmap(computer, brand = "brand", attr = "high_end:business")
plot(result, plots = "brand")
plot(result, plots = c("brand", "attr"))
plot(result, scaling = 1, plots = c("brand", "attr"))
prmap(
  retailers,
  brand = "retailer",
  attr = "good_value:cluttered",
  pref = c("segment1", "segment2")
) \%>\% plot(plots = c("brand", "attr", "pref"))

}
\seealso{
\code{\link{prmap}} to calculate results

\code{\link{summary.prmap}} to plot results
}
