% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acf_plots.R
\name{acf_plots}
\alias{acf_plots}
\title{Create Auto Correlation Plots for Models}
\usage{
acf_plots(input, columns, pre_model = FALSE, stan = FALSE)
}
\arguments{
\item{input}{list List of the model output}

\item{columns}{vector The target columns to assess}

\item{pre_model}{bool If you are passing the pre-model}

\item{stan}{bool If you are using the stan model}
}
\value{
plotted objects
}
\description{
Create auto correlation plots for the models to test if there
is any high autocorrelation in the sampling space, which would
imply that sampler should be adjusted or the data needs to be
adjusted.
}
\examples{
columns <- c("fruit", "veg", "tobacco")
fruit_v_coef <- generate_coefficient(100, 0.3, 0.8, 0.95)
veg_v_coef <- generate_coefficient(100, 0.25, 0.75, 0.95)
tob_v_coef <- generate_coefficient(100, 0.4, 0.7, 0.95)
validity_coefficients <- c(fruit_v_coef, veg_v_coef, tob_v_coef)
data <- data.frame(
 list(
   "BMI" = rnorm(100, mean = 0, sd = 1),
   "fruit" = rnorm(100, mean = 0, sd = 1),
   "veg" = rnorm(100, mean = 0, sd = 1),
   "tobacco" = rnorm(100, mean = 0, sd = 1)
 )
)
output <- acme_model(data, columns)
lambda <- attenuation_matrix(
  output,
  columns,
  validity_coefficients,
)
model_output <- multivariate_model(
  "BMI ~ fruit + veg + tobacco",
  data = data,
  columns = columns,
  a_c_matrix = lambda$matrix,
  sds = lambda$sds,
  variances = lambda$variances,
  univariate = TRUE
)
acf_plots(model_output$naive, columns)
}
