% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate_view.R
\name{plate_view}
\alias{plate_view}
\title{Real-Time Plate View}
\usage{
plate_view(df, meta, plate = 96)
}
\arguments{
\item{df}{Real-time dataframe}

\item{meta}{Dataframe containing well IDs and Sample IDs to title each facet.}

\item{plate}{Integer either 96 or 384 to denote microplate type.}
}
\value{
A ggplot object
}
\description{
Converts the real-time data into a ggplot figure. The layout is either 8x12
or 16x24 for 96- and 384-well plates, respectively.
}
\examples{
# This test takes >5 sec
\donttest{
file <- system.file(
  "extdata/input_files",
  file = "test2.xlsx",
  package = "quicR"
)

# Get the real-time data.
df_ <- get_real(file, ordered = FALSE)[[1]] |>
  as.data.frame()

sample_locations <- get_sample_locations(
  file,
  dilution_bool = TRUE,
  dilution_fun = function(x) -log10(x)
)

plate_view(df_, sample_locations)
}

}
